<?php

/**
 * chown module for phpWebSite
 *
 * @author rck <http://www.kiesler.at/>
 */

require_once(PHPWS_SOURCE_DIR . "core/Pager.php");

class PHPWS_chown {


	var $_pager;
	var $_sortid = "counter desc";
	var $_id;

	var $bots=null;
   


	function PHPWS_own() {

		include($GLOBALS["core"]->source_dir.
			"mod/chown/conf/config.php");

	}



	function parameters_set() {

		global $_REQUEST;

		return(	($_REQUEST['user'] ||
	       		 $_REQUEST['group'])	&&

			$_REQUEST['directory']);

	}



	function genForm($msg) {

		$tags=array();

		$tags['MESSAGE']=$msg;

		$directory=$_SESSION['translate']->it('File or Directory');

		$dir_label='<label for="directory">'.$directory.'</label>';
		$dir_el=PHPWS_Form::formTextField('directory', '', 50);

		$tags['DIRECTORY_FIELD']=$dir_el;
		$tags['DIRECTORY_LABEL']=$dir_label;


		$user=$_SESSION['translate']->it('New User (Name or Number)');

		$us_label='<label for="user">'.$user.'</label>';
		$us_el=PHPWS_Form::formTextField('user', '', 3);

		$tags['USER_FIELD']=$us_el;
		$tags['USER_LABEL']=$us_label;

		
		$group=$_SESSION['translate']->it('New Group (Name or Number)');

		$gr_label='<label for="group">'.$group.'</label>';
		$gr_el=PHPWS_Form::formTextField('group', '', 3);

		$tags['GROUP_FIELD']=$gr_el;
		$tags['GROUP_LABEL']=$gr_label;

		$mod_el=PHPWS_Form::formHidden('module', 'chown');
		$tags['MODULE']=$mod_el;


		$submit=$_SESSION['translate']->it('chown');
		$su_el=PHPWS_Form::formSubmit($submit, 'chown_op');
		$tags['SUBMIT_BUTTON']=$su_el;


		return(PHPWS_Template::processTemplate($tags, 'chown',
			'chown.tpl'));

	}



	function genIntroduction() {
		$txt ='Please enter enter a new user and/or group for the ';
		$txt.='directory or file of your choice. You can either use ';
		$txt.='the group/user number or the group/user name.';

		return($_SESSION['translate']->it("<p>$txt</p>"));
	}

	
	function checkSafeMode() {
		$safe_mode=ini_get('safe_mode');

		if(!$safe_mode)
			return(null);

		$txt ='<em>Warning:</em> You have safe-mode enabled. You ';
		$txt.='probably won\'t be able to chown files or directories.</em>';

		return($_SESSION['translate']->it("<p>$txt</p>", $txt));
	}


	function checkOpenBasedir() {

		$open_basedir=ini_get('open_basedir');

		if(!$open_basedir)
			return(null);

		$txt ='<em>Warning:</em> Open_basedir restriction in effect. ';
		$txt.='You host restricts php directory access to the ';
		$txt.="following directories: [var1]";

		return($_SESSION['translate']->it("<p>$txt</p>", $open_basedir));

	}


	function checkExists($what) {

		if(@file_exists($what))
			return(null);

		$txt = "<strong>Error:</strong> The file or directory ";
		$txt.= "&ldquo;[var1]&rdquo; does not exist. Have another ";
		$txt.= "try!";

		return($_SESSION['translate']->it("<p>$txt</p>", $what));
	}


	function doChown($what, $user, $group) {

		if(strlen($user)>0 && strlen($group)>0) {

			if(	@chown($what, $user) &&
				@chgrp($what, $group))

				return(null);

			$txt = "<strong>Error:</strong> Could not change ownership ";
			$txt.= "of &ldquo;[var1]&rdquo; to user &ldquo;[var2]&rdquo; ";
			$txt.= "and group &ldquo;[var3]&rdquo;!";

			return($_SESSION['translate']->it("<p>$txt</p>",
				$what, $user, $group));
		} else
		if(strlen($group)>0) {

			if(	@chgrp($what, $group))

				return(null);

			$txt = "<strong>Error:</strong> Could not change ownership ";
			$txt.= "of &ldquo;[var1]&rdquo; to group &ldquo;[var2]&rdquo;!";

			return($_SESSION['translate']->it("<p>$txt</p>",
				$what, $group));

		} else {

			if(	@chown($what, $user))

				return(null);

			$txt = "<strong>Error:</strong> Could not change ownership ";
			$txt.= "of &ldquo;[var1]&rdquo; to user &ldquo;[var2]&rdquo;!";

			return($_SESSION['translate']->it("<p>$txt</p>",
				$what, $user));
		}
	}


	function genOkMsg($what, $user, $group) {

		if((strlen($user)>0) && (strlen($group)>0)) {

			$txt = "Successfully changed the ownership of ";
			$txt.= "&ldquo;[var1]&rdquo; to user &ldquo;[var2]&rdquo; ";
			$txt.= "and group &ldquo;[var3]&rdquo;!";

			return($_SESSION['translate']->it("<p>$txt</p>",
				$what, $user, $group));

		} else
		if(strlen($group)>0) {

			$txt = "Successfully changed the ownership of ";
			$txt.= "&ldquo;[var1]&rdquo; to group ";
			$txt.= "&ldquo;[var2]&rdquo;!";

			return($_SESSION['translate']->it("<p>$txt</p>",
				$what, $group));

		} else {

			$txt = "Successfully changed the ownership of ";
			$txt.= "&ldquo;[var1]&rdquo; to user ";
			$txt.= "&ldquo;[var2]&rdquo;!";

			return($_SESSION['translate']->it("<p>$txt</p>",
				$what, $user));
		}
	}


	function after_chown() {

		global $_REQUEST;

		$directory=$_REQUEST['directory'];
		$user=$_REQUEST['user'];
		$group=$_REQUEST['group'];


		$msg=$this->checkExists($directory);
		if(isset($msg))
			return($msg);

		$msg=$this->doChown($directory, $user, $group);
		if(isset($msg))
			return($msg);
		else
			return(genOkMsg($directory, $user, $group));
	}



	function showChown() {
		if(!$_SESSION["OBJ_user"]->isDeity()) {
			$text="please log in as deity to do that.";
			$text=$_SESSION["translate"]->it($text);

			return("<p>$text</p>");
		}

		if($this->parameters_set())
			$msg=$this->after_chown();
		else
			$msg=$this->genIntroduction();

		$msg.=$this->checkSafeMode();
		$msg.=$this->checkOpenBasedir();

		return($this->genForm($msg));
	}

} 


?>
