<?php

/**
 * chmod module for phpWebSite
 *
 * @author rck <http://www.kiesler.at/>
 */

require_once(PHPWS_SOURCE_DIR . "core/Pager.php");

class PHPWS_chmod {


	var $_pager;
	var $_sortid = "counter desc";
	var $_id;

	var $bots=null;
   


	function PHPWS_visitors() {

		include($GLOBALS["core"]->source_dir.
			"mod/chmod/conf/config.php");

	}



	function parameters_set() {

		global $_REQUEST;

		return(	$_REQUEST['rights'] &&
			$_REQUEST['directory']);

	}



	function genForm($msg) {

		$tags=array();

		$tags['MESSAGE']=$msg;

		$directory=$_SESSION['translate']->it('Directory');

		$dir_label='<label for="directory">'.$directory.'</label>';
		$dir_el=PHPWS_Form::formTextField('directory', '', 50);

		$tags['DIRECTORY_FIELD']=$dir_el;
		$tags['DIRECTORY_LABEL']=$dir_label;



		$rights=$_SESSION['translate']->it('New Rights (Octal)');

		$ri_label='<label for="rights">'.$rights.'</label>';
		$ri_el=PHPWS_Form::formTextField('rights', '', 3);

		$tags['RIGHTS_FIELD']=$ri_el;
		$tags['RIGHTS_LABEL']=$ri_label;

		$mod_el=PHPWS_Form::formHidden('module', 'chmod');
		$tags['MODULE']=$mod_el;


		$submit=$_SESSION['translate']->it('chmod');
		$su_el=PHPWS_Form::formSubmit($submit, 'chmod_op');
		$tags['SUBMIT_BUTTON']=$su_el;


		return(PHPWS_Template::processTemplate($tags, 'chmod',
			'chmod.tpl'));

	}



	function genIntroduction() {
		$example1='(eg 777)';
		$example2='(eg /home/users/somewhere)';
		$txt ='Please enter the right you want to grant [var1] ';
		$txt.='as well as the corresponding file or directory [var2].';

		return($_SESSION['translate']->it("<p>$txt</p>",
			$example1, $example2));
	}

	
	function checkSafeMode() {
		$safe_mode=ini_get('safe_mode');

		if(!$safe_mode)
			return(null);

		$txt ='<em>Warning:</em> You have safe-mode enabled. You ';
		$txt.='probably won\'t be able to chmod directories.</em>';

		return($_SESSION['translate']->it("<p>$txt</p>", $txt));
	}


	function checkOpenBasedir() {

		$open_basedir=ini_get('open_basedir');

		if(!$open_basedir)
			return(null);

		$txt ='<em>Warning:</em> Open_basedir restriction in effect. ';
		$txt.='You host restricts php directory access to the ';
		$txt.="following directories: [var1]";

		return($_SESSION['translate']->it("<p>$txt</p>", $open_basedir));

	}


	function checkExists($what) {

		if(@file_exists($what))
			return(null);

		$txt = "<strong>Error:</strong> The file or directory ";
		$txt.= "&ldquo;[var1]&rdquo; does not exist. Have another ";
		$txt.= "try!";

		return($_SESSION['translate']->it("<p>$txt</p>", $what));
	}


	function doChmod($what, $rights) {

		$val=intval($rights, 8);

		if(@chmod($what, $val))
			return(null);

		$txt = "<strong>Error:</strong> Could not change rights ";
		$txt.= "of &ldquo;[var1]&rdquo; to &ldquo;[var2]&rdquo;! ";

		return($_SESSION['translate']->it("<p>$txt</p>",
			$what, $rights));
	}


	function genOkMsg($what, $rights) {

		$txt = "Successfully changed the rights of [var1] ";
		$txt.= "to [var2]!";

		return($_SESSION['translate']->it("<p>$txt</p>",
			$what, $rights));
	}


	function after_chmod() {

		global $_REQUEST;

		$directory=$_REQUEST['directory'];
		$rights=$_REQUEST['rights'];


		$msg=$this->checkExists($directory);
		if(isset($msg))
			return($msg);

		$msg=$this->doChmod($directory, $rights);
		if(isset($msg))
			return($msg);
		else
			return(genOkMsg($directory, $rights));
	}



	function showChmod() {


		if(!$_SESSION["OBJ_user"]->isDeity()) {
			$text="please log in as deity to do that.";
			$text=$_SESSION["translate"]->it($text);

			return("<p>$text</p>");
		}

		if($this->parameters_set())
			$msg=$this->after_chmod();
		else
			$msg=$this->genIntroduction();

		$msg.=$this->checkSafeMode();
		$msg.=$this->checkOpenBasedir();

		return($this->genForm($msg));
	}

} 


?>
