<?php

/**
 * Portfolio module for phpWebSite
 *
 * @author rck <http://www.kiesler.at/>
 */

require_once(PHPWS_SOURCE_DIR . "core/Pager.php");

class PHPWS_portfolio {


	var $_pager;
	var $_sortid = "counter desc";
	var $_id;

	
	var $_am_avail;
	var $_hunt_nonprofile=false;
	var $_active=true;


	var $_author=null;
	var $_module=null;
	var $_ctype=null;


	function PHPWS_portfolio() {

		include(	$GLOBALS["core"]->source_dir .
				"mod/portfolio/conf/config.php");


		$this->_hunt_nonprofile=$hunt_nonprofile;
		$this->_active         =$active;

		require_once(PHPWS_SOURCE_DIR."mod/boost/class/Boost.php");
		$boost = new PHPWS_Boost;

		$versionInfo=$boost->getVersionInfo("Article Manager");

		if($versionInfo==FALSE)
			$this->_am_avail=false;
		else
			$this->_am_avail=true;

		$this->_am_avail=true;
	}


	function setAuthor($author) {

		$this->_author=$author;

	}


	function setModule($module) {

		$this->_module=$module;

	}


	function setCType($ctype) {

		$this->_ctype=$ctype;

	}



	function genAuthorSQL() {

		$prefix=$GLOBALS['core']->tbl_prefix;

		$sql = "SELECT distinct username, user_id ";
		$sql.= "FROM ${prefix}mod_article, ${prefix}mod_users ";
		$sql.= "WHERE user_id=created_id AND ";
		$sql.=  "approved!=0 ";
		$sql.= "ORDER BY username";

		return($sql);
	}


	function genAuthorProfileSQL($author_id) {

		$prefix=$GLOBALS['core']->tbl_prefix;

		if($this->_am_avail) {

			$sql  = "SELECT id ";
			$sql .= "FROM ${prefix}mod_article ";
			$sql .= "WHERE created_id=\"$author_id\" ";
			$sql .=	  "AND template=\"Profile\" ";


			if($this->_hunt_nonprofile) {
				$sql .= "UNION\n";

				$sql .= "SELECT id ";
				$sql .= "FROM ${prefix}mod_article ";
				$sql .= "WHERE created_id=\"$author_id\" ";
			}

			return($sql);

		} else {
			return(null);
		}
	}


	function genArticleURL($caption, $author_id) {


		$sql=$this->genAuthorProfileSQL($author_id);

		if(!$sql)
			return("could not generate SQL.");

		$result=$GLOBALS['core']->getAllAssoc($sql);

		if(!$result || !$result[0])
			return($caption);

		$fields=array();
		$fields["view"]=$result[0]["id"];

		$url=PHPWS_Text::moduleLink($caption, "article", $fields);

		return($url);
	}


	function genAuthorLink($author_id, $author) {

		$url=$this->genArticleURL($author, $author_id);

		return($url);
	}


	function genAuthorLinks() {

		$sql=$this->genAuthorSQL();
		$result=$GLOBALS['core']->getAllAssoc($sql);

		$content=null;

		foreach($result as $nr => $value) {

			$author=$value["username"];
			$author_id=$value["user_id"];

			$content.="<p>";
			$content.=$this->genAuthorLink($author_id, $author);
			$content.="</p>\n";
		}

		return($content);

	}


	function genArticleListSQL($author_id, $type) {

		$prefix=$GLOBALS['core']->tbl_prefix;

		$sql ="SELECT * FROM ${prefix}mod_article ";
		$sql.="WHERE approved!=0 ";

		if(!empty($author_id))
			$sql.="AND created_id=$author_id ";

		if(!empty($type))
			$sql.="AND template=\"$type\" ";

		return($sql);
	}


	function genListSQL($author_id, $module, $type) {

		if($module=="article")
			return($this->genArticleListSQL($author_id, $type));
		else
			return(null);

	}

	function showList() {


		if(!$this->_active)
			return;


		$author=$this->_author;
		$module=$this->_module;
		if(empty($module))
			$module=$_REQUEST["portfolio_module"];

		$type=$this->_ctype;
		if(empty($type))
			$type=$_REQUEST["portfolio_ctype"];


		$sql=$this->genListSQL($author, $module, $type);
		if(!$sql)
			return(null);

		$result=$GLOBALS['core']->getAllAssoc($sql);

		$content="<ul>\n";


		foreach($result as $nr => $value) {

			$caption=$value["title"];
			if(empty($caption))
				$caption="<em>(nameless)</em>";

			$fields=array();
	                $fields["view"]=$value["id"];

			$url=PHPWS_Text::moduleLink($caption, "article", $fields);

			$content.="\t<li>$url</li>\n";
		}

		if($content == "<ul>\n")
			$content="no content.";
		else
			$content.="</ul>";

		return($content);
	}


	function showMenu() {

		if(!$this->_active)
			return;

		return($this->genAuthorLinks());
		
	}


	function getAuthorID() {

		if(isset($_REQUEST["portfolio_author"]))
			return($_REQUEST["portfolio_author"]);

		$in_am=($_REQUEST['module'] == 'article');
		$view_id=$_REQUEST['view'];
		$viewing=!empty($view_id);

		if(!$in_am || !$viewing)
			return(null);

		$am=new PHPWS_Article($view_id);

		return($am->created_id);
	}


	function haveArticle() {


		$in_am=($_REQUEST['module'] == 'article');

		$viewing=!empty($_REQUEST['view']);

		return($in_am && $viewing);
	}


	function getArticleAuthorName() {

		if(!$this->haveArticle())
			return(null);

		$view_id=$_REQUEST['view'];

		if(empty($view_id))
			return(null);

		$am=new PHPWS_Article($view_id);

		return($am->created_username);
	}


	function id2name($author_id) {

		if(!$author_id)
			return("Guest");

		$sql ="SELECT username from ${prefix}mod_users ";
		$sql.="WHERE user_id=$author_id";

		$result=$GLOBALS['core']->getAllAssoc($sql);

		if(empty($result))
			return("Unknown");
		else
			return($result[0]["username"]);
	}


	function getAuthorName() {

		if($this->haveArticle())
			return($this->getArticleAuthorName());

		$author_id=$_REQUEST["portfolio_author"];

		if(empty($author_id))
			// return("no data.");
			return(null);

		$author_name=$this->id2name($author_id);

		if(empty($author_name))
			return("could not resolve id $author_id");
		else
			return($author_name);
	}



	function genArticleTypesSQL($author_id) {

		$prefix=$GLOBALS['core']->tbl_prefix;

		$sql ="SELECT template type, count(id) count ";

		$sql.="FROM ${prefix}mod_article ";
		$sql.="WHERE created_id=$author_id AND ";
		$sql.=  "approved!=0 ";
		$sql.="GROUP BY Template ORDER BY template";

		return($sql);
	}




	function getArticleTypes($author_id=null) {
		if(empty($author_id))
			$author_id=$this->getAuthorID();

		if(empty($author_id))
			return(null);

		$sql=$this->genArticleTypesSQL($author_id);

		$result=$GLOBALS['core']->getAllAssoc($sql);

		return($result);
	}


	function getTypes($author_id=null) {

		if(empty($author_id))
			return($author_id=$this->getAuthorID());
		if(empty($author_id))
			return(null);

		return($this->getArticleTypes($author_id));

	}


	function genArticleLink($author_id, $template, $caption) {

		$html ="<a href=\"./index.php?module=portfolio&amp;";
		$html.="portfolio_op=list&amp;";
		$html.="portfolio_module=article&amp;";

		if(!empty($author_id))
			$html.="portfolio_author=$author_id&amp;";

		if(!empty($template))
			$html.="portfolio_ctype=$template";
			
		$html.="\">";

		$html.=$caption;

		$html.="</a>";

		return($html);
	}


	function renderTypes($types) {

		$html="<ul>\n";

		if(empty($types))
			return("nothing to see here.");

		foreach($types as $nr => $value) {
			$html.="\t<li>";

			$author_id=$this->getAuthorID();

			$caption=$value['type']." (".
				$value['count'].")";

			$html.=$this->genArticleLink($author_id,
				$value['type'], $caption);

			$html.="</li>\n";
		}


		if($html != "<ul>\n")
			$html.="</ul>\n";
		else
			$html="<em>no types</em>";


		return($html);

	}


	function showWorks() {


		$author_id=$this->getAuthorID();

		if(empty($author_id))
			$author_id=$_REQUEST["portfolio_author"];

		if(empty($author_id))
			// return("no data.");
			return(null);

		$types=$this->getTypes($author_id);

		return($this->renderTypes($types));
	}

   } 


?>
