<?php	//
	//
	// Health Module for phpWebSite
	//
	// (c) 2005 rck <http://www.kiesler.at/>
	//
	//



	define("OK", "0");
	define("WARN", "1");
	define("ERROR", "2");



	function getHealthPath() {

		return(realpath("."));

	}

	function getPWSPath() {

		return(realpath("../.."));

	}



	function queryHealthFiles() {

		$health=getHealthPath();


		$files=array();

		$files[]="index.php";
		$files[]="manual.php";
		$files[]="class/health.php";
		$files[]="boost/install.php";
		$files[]="boost/uninstall.php";
		$files[]="conf/boost.php";
		$files[]="conf/config.php";
		$files[]="conf/controlpanel.php";
		$files[]="conf/layout.php";
		$files[]="img/health.gif";
		$files[]="inc/runtime.php";


		$missing=array();

		foreach($files as $nr => $file)
			if(!file_exists($health."/".$file))
				$missing[]=$file;


		$result['name']="Health Files";

		if(count($missing)>0) {

			$result['code']=ERROR;

			$result['text']="<p>The following files are missing in $health: <ul>\n";

			foreach($missing as $nr => $file)
				$result['text'].="<li>$health/$file</li>\n";

			$result['text'].="</ul></p>\n";
			$result['text'].="<p>Please install them and try again.</p>";

		} else {


			$result['code']=OK;

			$result['text'] ="<p>found all ".count($files)." files of ";
			$result['text'].="health in $health.</p>";
		}


		return($result);

	}


	function queryHealthSanity() {

		$health=getHealthPath()."/class/health.php";

                require_once(getHealthPath()."/conf/boost.php");

		$version="0.3";
		$md5=md5_file($health);



		// 0.2 and 0.3 are the same -- the only new thing
		// in 0.3 is manual.php

		$checksums["0.2"]="3debd68f3e7a95a6f48e53dc30dd45d4";
		$checksums["0.3"]="3debd68f3e7a95a6f48e53dc30dd45d4";


		$available=!empty($checksums[$version]);

		$result=array();
		$result['name']="Health Sanity";


		if(!$available) {

			$result['code']=ERROR;
			$result['text'] ="<p>Don't know about Health $version -- ";
			$result['text'].="did you write it yourself? Anyway, the ";
			$result['text'].="MD5 checksum I got is ${md5}.</p>";

		} else
		if($md5 == $checksums[$version]) {

			$result['code'] =OK;
			$result['text'] ="<p>The checksum of your installed ";
			$result['text'].="Health $version matches with the one ";
			$result['text'].="I know about.</p>";

		} else {

			$result['code'] = ERROR;

			$result['text'] = "<p>This Health $version has been tampered ";
			$result['text'].= "with. Please download the newest version from ";

			$result['text'].= "<a href=\"http://www.kiesler.at/article147.html\">kiesler.at</a>, ";

			$result['text'].= "reinstall it and run this check again. If this error ";
			$result['text'].= "persists, please contact the Author via ";

			$result['text'].= "<a href=\"http://www.kiesler.at/index.php?module=phpwsbb&PHPWSBB_MAN_OP=list\">";
			$result['text'].= "his forums</a>.";

		}

		return($result);
	}


	function queryPWSFiles() {

		$pws=getPWSPath();

		$files=array();

		$files[]="index.php";
		$files[]="conf/allowedImageTypes.php";
		$files[]="conf/cache.php";
		$files[]="conf/core_info.php";
		$files[]="conf/dateSettings.en.php";
		$files[]="conf/javascriptSettings.php";
		$files[]="conf/textSettings.php";

		$files[]="core/Array.php";
		$files[]="core/Cache.php";
		$files[]="core/Core.php";
		$files[]="core/Database.php";
		$files[]="core/DateTime.php";
		$files[]="core/Debug.php";
		$files[]="core/EZelement.php";
		$files[]="core/EZform.php";
		$files[]="core/Error.php";
		$files[]="core/File.php";
		$files[]="core/Form.php";
		$files[]="core/Item.php";
		$files[]="core/List.php";
		$files[]="core/Manager.php";
		$files[]="core/Message.php";
		$files[]="core/Pager.php";
		$files[]="core/Template.php";
		$files[]="core/Text.php";
		$files[]="core/WizardBag.php";

		$files[]="core/img/manager/down_pointer.png";
		$files[]="core/img/manager/sort_none.png";
		$files[]="core/img/manager/up_pointer.png";
		$files[]="core/img/manager/up_pointer.png";

		$files[]="templates/defaultList.tpl";
		$files[]="templates/defaultRow.tpl";
		$files[]="templates/error.tpl";
		$files[]="templates/message.tpl";


		$missing=array();

		foreach($files as $nr => $file)
			if(!file_exists($pws."/".$file))
				$missing[]=$file;

		$result['name']="phpWebSite Files";

		if(count($missing)>0) {

			$result['code']=ERROR;

			$result['text']="<p>The following files are missing in $pws: <ul>\n";

			foreach($missing as $nr => $file)
				$result['text'].="<li>$pws/$file</li>\n";

			$result['text'].="</ul></p>\n";
			$result['text'].="<p>Please install them and try again.</p>";

		} else {

			$result['code']=OK;

			$result['text'] ="<p>found all ".count($files)." files of ";
			$result['text'].="phpWebSite in $pws</p>";

		}

		return($result);
	}


	function querySourceDir() {
                $pws=getPWSPath();

		if(substr($pws, -1) != DIRECTORY_SEPARATOR)
			$pws.=DIRECTORY_SEPARATOR;

		require_once($pws."/conf/config.php");

		$result['name']="Source Directory";

		if($pws == $source_dir) {

			$result['code']=OK;

			$result['text'] ="<p>phpWebSite source directory correctly ";
			$result['text'].="set to $pws</p>";

		} else {

			$result['code']=ERROR;

			$result['text'] ="<p>phpWebSite source directory wrong. ";
			$result['text'].="You conf/config.php says, it's $source_dir ";
			$result['text'].="but it looks more like $pws to me!</p>";
		}

		return($result);
	}


	function quickRender($result) {


		$html="<h2>".$result['name'];

		if($result['code']==OK)
			$html.=" - OK";
		else
		if($result['code']==WARN)
			$html.=" - Warning";
		else
		if($result['code']==ERROR)
			$html.=" - ERROR";

		$html.="</h2>\n";


		$html.=$result['text'];

		return($html);
	}



	echo "<h1>Health MANUAL MODE</h1>\n";
	echo "<p>Health is a phpWebSite Module brought to you by ";
	echo "<a href=\"http://www.kiesler.at/\">kiesler.at</a></p>\n";


	$result=queryHealthFiles();
	echo(quickRender($result));

	if($result['code'] != OK)
		exit;

	$result=queryHealthSanity();
	echo(quickRender($result));

	if($result['code'] != OK)
		exit;

	$result=queryPWSFiles();
	echo(quickRender($result));

	$result=querySourceDir();
	echo(quickRender($result));
?>
