<?php

/**
 * Portfolio module for phpWebSite
 *
 * @author rck <http://www.kiesler.at/>
 */

require_once(PHPWS_SOURCE_DIR . "core/Pager.php");

class PHPWS_portfolio {

	var $_pager;
	var $_sortid = "counter desc";
	var $_id;

	var $_am_avail;
	var $_hunt_nonprofile=false;
	var $_active=true;

	function PHPWS_portfolio() {

		include(	$GLOBALS["core"]->source_dir .
				"mod/portfolio/conf/config.php");


		$this->_hunt_nonprofile=$hunt_nonprofile;
		$this->_active         =$active;

		require_once(PHPWS_SOURCE_DIR."mod/boost/class/Boost.php");
		$boost = new PHPWS_Boost;

		$versionInfo=$boost->getVersionInfo("Article Manager");

		if($versionInfo==FALSE)
			$this->_am_avail=false;
		else
			$this->_am_avail=true;

		$this->_am_avail=true;
	}


	function genAuthorSQL() {

		$prefix=$GLOBALS['core']->tbl_prefix;

		$sql = "SELECT distinct username, user_id ";
		$sql.= "FROM ${prefix}mod_article, ${prefix}mod_users ";
		$sql.= "WHERE user_id=created_id AND ";
		$sql.=  "approved!=0 ";
		$sql.= "ORDER BY username";

		return($sql);
	}


	function genAuthorProfileSQL($author_id) {

		$prefix=$GLOBALS['core']->tbl_prefix;

		if($this->_am_avail) {

			$sql  = "SELECT id ";
			$sql .= "FROM ${prefix}mod_article ";
			$sql .= "WHERE created_id=\"$author_id\" ";
			$sql .=	  "AND template=\"Profile\" ";


			if($this->_hunt_nonprofile) {
				$sql .= "UNION\n";

				$sql .= "SELECT id ";
				$sql .= "FROM ${prefix}mod_article ";
				$sql .= "WHERE created_id=\"$author_id\" ";
			}

			return($sql);

		} else {
			return(null);
		}
	}


	function genArticleURL($caption, $author_id) {


		$sql=$this->genAuthorProfileSQL($author_id);

		if(!$sql)
			return("could not generate SQL.");

		$result=$GLOBALS['core']->getAllAssoc($sql);

		if(!$result || !$result[0])
			return($caption);

		$fields=array();
		$fields["view"]=$result[0]["id"];

		$url=PHPWS_Text::moduleLink($caption, "article", $fields);

		return($url);
	}


	function genAuthorLink($author_id, $author) {

		$url=$this->genArticleURL($author, $author_id);

		return($url);
	}


	function genAuthorLinks() {

		$sql=$this->genAuthorSQL();
		$result=$GLOBALS['core']->getAllAssoc($sql);

		$content=null;

		foreach($result as $nr => $value) {

			$author=$value["username"];
			$author_id=$value["user_id"];

			$content.="<p>";
			$content.=$this->genAuthorLink($author_id, $author);
			$content.="</p>\n";
		}

		return($content);

	}

	function showList() {

		if(!$this->_active)
			return;

		return("work in progress");
	}


	function showMenu() {

		if(!$this->_active)
			return;

		return($this->genAuthorLinks());
		
	}

   } 


?>
