<?php	

	require_once "../inc/all_sites.php";


	function connect() {

		global $dbversion, $dbuser, $dbpass, $dbhost, $dbname, $pws;

                if(substr($pws, -1) != DIRECTORY_SEPARATOR)
			$pws.=DIRECTORY_SEPARATOR;

		require_once($pws."/lib/pear/DB.php");

		$connect_string="$dbversion://$dbuser:$dbpass@$dbhost/$dbname";

		return(DB::connect($connect_string));
	}



	function mk_xml($site, $urls) {


		$xml ='<?xml version="1.0" encoding="UTF-8"?>'."\n";
		$xml.='<urlset xmlns="http://www.google.com/schemas/sitemap/0.84">'."\n";

		foreach($urls as $nr=>$row) {

			$url=$row['url'];
			$lastmod=$row['lastmod'];

			$xml.=" <url>\n";
			$xml.="  <loc>$site$url</loc>\n";
			$xml.="  <lastmod>$lastmod</lastmod>\n";
			$xml.=" </url>\n";
		}
		$xml.="</urlset>\n";

		return($xml);
	}


	function fetch_article_urls($db, $super_short) {

		$sql ='SELECT id, DATE_FORMAT(updated_date, "%Y-%m-%d") updated, DATE_FORMAT(created_date, "%Y-%m-%d") created ';
		$sql.='FROM mod_article ';
		$sql.='WHERE approved!=0 ';
		$sql.='ORDER BY id';


		$res=$db->query($sql);

		if(DB::isError($res))
			return(array());

		$data=array();

		while($row=$res->fetchRow(DB_FETCHMODE_ASSOC)) {

			extract($row);


			$new=array();

			if($super_short)
				$new['url']="article$id.html";
			else
				$new['url']="index.php?module=article&amp;view=$id";

			if($updated > $created)
				$new['lastmod']=$updated;
			else
				$new['lastmod']=$created;


			$data[]=$new;
		}


		return($data);

	}



	function fetch_announcement_urls($db, $super_short) {

		$sql ='SELECT id, DATE_FORMAT(dateUpdated, "%Y-%m-%d") updated, DATE_FORMAT(dateCreated, "%Y-%m-%d") created ';
		$sql.='FROM mod_announce ';
		$sql.='WHERE approved!=0 AND active=1 ';
		$sql.='ORDER BY id';

		$res=$db->query($sql);

		if(DB::isError($res))
			return(array());

		$data=array();

		while($row=$res->fetchRow(DB_FETCHMODE_ASSOC)) {

			extract($row);

			$new=array();

			if($super_short)
				$new['url']="announcement$id.html";
			else
				$new['url']="index.php?module=announce&amp;ANN_user_op=view&amp;ANN_id=$id";

			if($updated > $created)
				$new['lastmod']=$updated;
			else
				$new['lastmod']=$created;

			$data[]=$new;
		}

		return($data);

	}



	function fetch_page_urls($db, $super_short) {

		$sql = 'SELECT id, DATE_FORMAT(updated_date, "%Y-%m-%d") updated, DATE_FORMAT(created_date, "%Y-%m-%d") created ';
		$sql.='FROM mod_pagemaster_pages ';
		$sql.='WHERE approved!=0 AND active=1 ';
		$sql.='ORDER BY id';

		$res=$db->query($sql);

		if(DB::isError($res))
			return(array());

		while($row=$res->fetchRow(DB_FETCHMODE_ASSOC)) {

			extract($row);

			$new=array();

			if($super_short)
				$new['url']="page$id.html";
			else
				$new['url']="index.php?module=pagemaster&amp;PAGE_user_op=view_page&amp;PAGE_id=$id";

			if($updated > $created)
				$new['lastmod']=$updated;
			else
				$new['lastmod']=$created;

			$data[]=$new;

		}

		return($data);

	}



	function fetch_thread_urls($db, $super_short) {

		$sql ='SELECT id, DATE_FORMAT(FROM_UNIXTIME(updated), "%Y-%m-%d") updated, DATE_FORMAT(FROM_UNIXTIME(created), "%Y-%m-%d") created ';
		$sql.='FROM mod_phpwsbb_threads ';
		$sql.='WHERE approved!=0 AND hidden!=1 ';
		$sql.='ORDER BY id';


		$res=$db->query($sql);

		if(DB::isError($res))
			return(array());

		$data=array();

		while($row=$res->fetchRow(DB_FETCHMODE_ASSOC)) {

			extract($row);


			$new=array();

			if($super_short)
				$new['url']="thread$id.html";
			else
				$new['url']="index.php?module=phpwsbb&amp;PHPWSBB_MAN_OP=view&amp;PHPWS_MAN_ITEMS=$id";

			if($updated > $created)
				$new['lastmod']=$updated;
			else
				$new['lastmod']=$created;


			$data[]=$new;
		}


		return($data);

	}


	function fetch_wiki_urls($db, $super_short) {

		$sql ='SELECT label, DATE_FORMAT(FROM_UNIXTIME(updated), "%Y-%m-%d") updated, DATE_FORMAT(FROM_UNIXTIME(created), "%Y-%m-%d") created ';
		$sql.='FROM mod_wiki_pages ';
		$sql.='ORDER BY label';

		$res=$db->query($sql);

		if(DB::isError($res))
			return(array());

		$data=array();

		while($row=$res->fetchRow(DB_FETCHMODE_ASSOC)) {

			extract($row);

			$new=array();

			$new['url']="index.php?module=wiki&amp;page=$label";

			if($updated > $created)
				$new['lastmod']=$updated;
			else
				$new['lastmod']=$created;

			$data[]=$new;

		}

		return($data);

	}


	$site_captions=array();

	foreach($sites as $nr => $site)
		$site_captions[]=$site['caption'];

	if($argc == 2) {


		if(in_array($argv[1], $site_captions))

			$chosen_site=$argv[1];

		else {

			echo("unsupported site ".$argv[1].".\n");
			echo("please choose one of those: ".implode(", ", $site_captions)."\n");

			exit(2);
		}

	} else {

		echo("sitemap needs an commandline-argument. It requires it to be one of these sites:\n");
		echo(implode(", ", $site_captions)."\n");

		exit(1);

	}


	foreach($sites as $nr => $site) {

		if($site['caption'] == $chosen_site) {

			$pws=realpath($site['path']);
			$config=$pws."/conf/config.php";

			file_exists($config) or
				die("need config!");

			require($config);

			$super_short=$site['super_short'];

			$db =connect();
			$articles=fetch_article_urls($db, $super_short);
			$announcements=fetch_announcement_urls($db, $super_short);
			$pages=fetch_page_urls($db, $super_short);
			$threads=fetch_thread_urls($db, $super_short);
			$wikis=fetch_wiki_urls($db, $super_short);
			$db->disconnect();

			$all=$articles;
			$all=array_merge($all, $announcements);
			$all=array_merge($all, $pages);
			$all=array_merge($all, $threads);
			$all=array_merge($all, $wikis);

			echo(mk_xml("http://$source_http", $all));
		}

	}
?>


