<?php
if (!class_exists('PHPWS_Article'))
  require_once(PHPWS_SOURCE_DIR . 'mod/article/class/Article.php');
/**
* This is the PHPWS_Article_Section class. It holds data for a single section in a article.
* It also contains functions for manipulation of the data and updating or
* deleting this section.
*
* @version $Id: Section.php,v 1.14 2004/11/12 03:28:17 adarkling Exp $
*
* @author Eloi George <eloi@NOSPAM.bygeorgeware.com>
* @basecode Adam Morton's PageMaster Module
* @package phpWebSite
* @module Article Manager
* @param int id : Database id of this article
* @param string title : Title of this article
* @param string text : Body text of this article
* @param array image : Array of image information
*          name = Image Name.
*          directory = Location of Image File.
*          height = Height of Image (in pixels).  NULL for Library Images.
*          width = Width of Image (in pixels).  NULL for Library Images.
*          alt = Alternate text to display for the Image.
*          link = If Image is a link, this contains the target URL.
*          caption = An optional line of text to display below the image
* @param string template : Template to use for displaying this section
* @param int article_id : Database Id of this section's parent article
* @param int new_page : Whether this section starts on a new page or not
* @param int edited : FLAG Whether this section has been changed.
* @param string old_image  : Name of the image that's being replaced
* @param string temp_image : Name of the new image sitting in a temporary position
*/
class PHPWS_Article_Section
{
        var $id;
        var $title;
        var $text;
        var $image;
        var $template;
        var $article_id;
        var $new_page;
        var $edited;
        var $old_image;
        var $temp_image;


        //////// article //////////////////////////////////////////////////////

        function are_articles_available() {
                $table=$GLOBALS['core']->sqlTableExists(
                        "mod_article", TRUE);

                return($table);
        }


        function get_article_edit_link($details) {
                $content = "";

                $id=$details["id"];

                $content .= "<a href=\"./index.php?module=article&";
                $content .= "edit=$id\" target=\"_blank\">";

                $content .= "[edit]";

                $content .= "</a>";

                return($content);
        }


        function get_article_link($details, $modus) {
                $content = "";

                $title=$details["title"];
                $id=$details["id"];

                $content .= "<a href=\"./index.php?module=article&";
                $content .= "view=$id\">";

                $content .= $title;

                $content .= "</a>";

                if(isset($modus["EDIT"]))
                        return($content . " " .
                                $this->get_article_edit_link($details));
                else
                        return($content);
        }


        function get_article_details($id) {
                $result=$GLOBALS["core"]->sqlSelect(
                        "mod_article", "id", $id);

                $details=array();
                $details["id"]=$result[0]["id"];
                $details["title"]=$result[0]["title"];

                return($details);
        }


        function swallow_article($id, $modus) {
                if(!$this->are_articles_available())
                        return("<em>cannot find article table!</em>");

                $details=$this->get_article_details($id);

                if(isset($details["id"]))
                        return($this->get_article_link($details, $modus));
                else
                        return("<em>cannot find article $id</em>");
        }


        function swallow_article_random($ids, $modus) {
                $ids=explode(",", $ids);
                $rnd=rand()%count($ids);

                return($this->swallow_article($ids[$rnd], $modus));
        }



/*
        //////// messages /////////////////////////////////////////////////////


        function are_messages_available() {
                $table=$GLOBALS['core']->sqlTableExists(
                        "mod_phpwsbb_messages", TRUE);

                return($table);
        }


        function get_message_details($id) {
                $result=$GLOBALS["core"]->sqlSelect(
                        "mod_phpwsbb_messages", "id", $id);

                $details=array();
                $details["id"]=$result[0]["id"];
                $details["body"]=$result[0]["body"];

                if(         isset($result["guestname"]) &&
                        ($result[0]["guestname"] != "")) {

                        $details["author"]=get_guest_link(
                                $result[0]["guestname"],
                                $result[0]["guestemail"]
                        );
                } else {

                }

                if(isset($result[0]["id"]))
                        return($result[0]["body"])
        }

        function swallow_message($id) {
        }

        function swallow_message_random($ids) {
                $ids=explode(",", $ids);
                $rnd=rand()%count($ids);

                return($this->swallow_message($ids[$message]));
        }

*/


        //////// section //////////////////////////////////////////////////////

        function are_sections_available() {
                $table=$GLOBALS['core']->sqlTableExists(
                        "mod_article_sections", TRUE);
                return($table);
        }


        function get_section($id) {
                $result=$GLOBALS["core"]->sqlSelect(
                        "mod_article_sections", "id", $id);

                if(isset($result[0]["text"]))
                        return($result[0]["text"]);
                else
                        return("<em>cannot find section $id</em>");
        }

        function swallow_section($id, $modus) {
                if(!$this->are_sections_available())
                        return("<em>cannot find section-table!</em>");
                else
                               return($this->get_section($id, $modus));
        }

        function swallow_section_random($ids, $modus) {
                $ids=explode(",", $ids);
                $rnd=rand()%count($ids);

                return($this->swallow_section($ids[$rnd], $modus));
        }



        //////// photos ///////////////////////////////////////////////////////


        function is_photoalbum_available() {
                $table=$GLOBALS['core']->sqlTableExists(
                        "mod_photoalbum_photos", TRUE);
                return($table);
        }


        function get_photo_edit_link($details) {
                $content = "";

                $album=$details["album"];
                $id=$details["id"];

                $content .= "<a href=\"./index.php?module=photoalbum&";
                $content .= "PHPWS_Album_id=$album&PHPWS_Photo_op=edit&";
                $content .= "PHPWS_Photo_id=$id\" target=\"_blank\">";

                $content .= "[edit]";

                $content .= "</a>";

                return($content);
        }


        function get_photo_link($details, $modus) {
                $content = "";


                $album=$details["album"];
                $id=$details["id"];
                $name=$details["name"];
                $dir=$details["dir"];

                $src="$dir$album/$name";
                $pic="<img src=\"".$src."\">";

                $content .= "<a href=\"./index.php?";
                $content .= "module=photoalbum&";
                $content .= "PHPWS_Photo_op=view&";
                $content .= "PHPWS_Album_id=$album&";
                $content .= "PHPWS_Photo_id=$id\">";

                $content .= $pic;

                $content .= "</a>";

                if(isset($modus["EDIT"]))
                        return($content . " " .
                                $this->get_photo_edit_link($details));
                else
                        return($content);
        }


        function get_thumb_details($id) {
                $result=$GLOBALS["core"]->sqlSelect(
                        "mod_photoalbum_photos", "id", $id);

                $details=array();
                $details["dir"]="./images/photoalbum/";
                $details["id"]=$result[0]["id"];
                $details["name"]=$result[0]["tnname"];
                $details["album"]=$result[0]["album"];

                return($details);
        }


        function get_photo_details($id) {
                $result=$GLOBALS["core"]->sqlSelect(
                        "mod_photoalbum_photos", "id", $id);

                $details=array();
                $details["dir"]="./images/photoalbum/";
                $details["id"]=$result[0]["id"];
                $details["name"]=$result[0]["name"];
                $details["album"]=$result[0]["album"];

                return($details);
        }


        function swallow_thumbnail($id, $modus) {

                if(!$this->is_photoalbum_available())
                        return("<em>cannot find photoalbum-table!</em>");


                $details=$this->get_thumb_details($id);

                if(isset($details["id"]))
                        return($this->get_photo_link($details, $modus));
                else
                        return("<em>cannot find thumbnail $id</em>");

        }


        function swallow_thumbnail_random($ids, $modus) {
                $ids=explode(",", $ids);
                $rnd=rand()%count($ids);

                return($this->swallow_thumbnail($ids[$rnd], $modus));
        }


        function swallow_photo($id, $modus) {

                if(!$this->is_photoalbum_available())
                        return("<em>cannot find photoalbum-table!</em>");

                $details=$this->get_photo_details($id);

                if(isset($details["id"]))
                        return($this->get_photo_link($details, $modus));
                else
                        return("<em>cannot find photo $id</em>");
        }


        function swallow_photo_random($ids, $modus) {
                $ids=explode(",", $ids);
                $rnd=rand()%count($ids);

                return($this->swallow_photo($ids[$rnd]));
        }



        //////// documents ////////////////////////////////////////////////////

        function is_files_available() {
                $table=$GLOBALS['core']->sqlTableExists(
                        "mod_documents_files", TRUE);
                return($table);
        }


        function get_file_edit_link($details) {
                $content = "";

                $doc=$details["doc"];

                $content .= "<a href=\"./index.php?module=documents&";
                $content .= "JAS_DocumentManager_op=editDocument&";
                $content .= "JAS_Document_id=$doc\" target=\"_blank\">";

                $content .= "[edit]";

                $content .= "</a>";

                return($content);
        }


        function get_file_link($details, $modus) {
                $content = "";

                $name=$details["name"];
                $id=$details["id"];

                $content .= "<a href=\"./index.php?module=documents&";
                $content .= "JAS_DocumentManager_op=downloadFile&";
                $content .= "JAS_File_id=$id\">";

                $content .= $name;

                $content .= "</a>";

                if(isset($modus["EDIT"]))
                        return($content . " " .
                                $this->get_file_edit_link($details));
                else
                        return($content);
        }


        function get_file_details($id) {
                $result=$GLOBALS["core"]->sqlSelect(
                        "mod_documents_files", "id", $id);

                $details=array();
                $details["name"]=$result[0]["name"];
                $details["id"]=$result[0]["id"];
                $details["doc"]=$result[0]["id"];

                return($details);
        }


        function swallow_file($id, $modus) {
                if(!$this->is_files_available())
                        return("<em>cannot find files table!</em>");

                $details=$this->get_file_details($id);

                if(isset($details["id"]))
                        return($this->get_file_link($details, $modus));
                else
                        return("<em>cannot find file $id</em>");
        }

        function swallow_file_random($ids, $modus) {
                $ids=explode(",", $ids);
                $rnd=rand()%count($ids);

                return($this->swallow_file($ids[$rnd], $modus));
        }



        //////// link /////////////////////////////////////////////////////////

        function is_links_available() {
                $table=$GLOBALS['core']->sqlTableExists(
                        "mod_linkman_links", TRUE);
                return($table);
        }


        function get_edit_link($details) {
                $content = "";

                $id=$details["id"];

                $content .= "<a href=\"./index.php?module=linkman&";
                $content .= "LMN_op=linkListAction&LMN_id=$id&";
                $content .= "LMN_editLink=1\" target=\"_blank\">";

                $content .= "[edit]";

                $content .= "</a>";

                return($content);
        }


        function get_link($details, $modus) {
                $content = "";

                $title=$details["title"];
                $description=$details["description"];
                $id=$details["id"];

                $content .= "<a href=\"./index.php?module=linkman&";
                $content .= "LMN_op=visitLink&LMN_id=$id\"";
                $content .= " title=\"$description\">";

                $content .= $title;

                $content .= "</a>";

                if(isset($modus["EDIT"]))
                        return($content. " ".
                                $this->get_edit_link($details));
                else
                        return($content);
        }


        function get_link_details($id) {
                $result=$GLOBALS["core"]->sqlSelect(
                        "mod_linkman_links", "id", $id);

                $details=array();
                $details["title"]=$result[0]["title"];
                $details["description"]=$result[0]["description"];
                $details["id"]=$result[0]["id"];

                return($details);
        }




        function swallow_link($id, $modus) {
                if(!$this->is_links_available())
                        return("<em>cannot find link table!</em>");

                $details=$this->get_link_details($id);

                if(isset($details["id"]))
                        return($this->get_link($details, $modus));
                else
                        return("<em>cannot find link $id</em>");
        }

        function swallow_breadcrumbs($ids, $modus) {
                if(!$this->is_links_available())
                        return("<em>cannot find link table!</em>");

                $ids=explode(",", $ids);

                foreach($ids as $nr => $val)
                        $ids[$nr]=$this->swallow_link($val, $modus);

                return(implode(" -> ", $ids));
        }


        function swallow_link_random($ids, $modus) {
                $ids=explode(",", $ids);
                $rnd=rand()%count($ids);

                return($this->swallow_link($ids[$rnd], $modus));
        }



        //////// dispatcher ///////////////////////////////////////////////////

        function dispatch_swallow($module, $id, $modus) {

                if($module == "article") {

                        $result = $this->swallow_article($id, $modus);

                } else
                if($module == "article-random") {

                        $result = $this->swallow_article_random($id, $modus);

                } else
                if($module == "breadcrumbs") {

                        $result = $this->swallow_breadcrumbs($id, $modus);

                } else
                if($module == "file") {

                        $result = $this->swallow_file($id, $modus);

                } else
                if($module == "file-random") {

                        $result = $this->swallow_file_random($id, $modus);

                } else
                if($module == "link") {

                        $result = $this->swallow_link($id, $modus);

                } else
                if($module == "link-random") {

                        $result = $this->swallow_link_random($id, $modus);

                 } else
                if($module == "photo") {

                        $result = $this->swallow_photo($id, $modus);

                } else
                if($module == "photo-random") {

                        $result = $this->swallow_photo_random($id, $modus);
                } else
                if($module == "section") {

                        $result = $this->swallow_section($id, $modus);

                } else
                if($module == "section-random") {

                        $result = $this->swallow_section_random($id, $modus);

                } else
                if($module == "thumbnail") {

                        $result = $this->swallow_thumbnail($id, $modus);

                } else
                if($module == "thumbnail-random") {

                        $result = $this->swallow_thumbnail_random($id, $modus);

                } else

                        $result = "<em>don't know how to handle ".
                                        "$module|$id</em>";

                return($result);
        }


        function parse_swallow($what, $modus) {

                $expr        =        "(\[swallow\=)" .
                                "(.*)" . "(\])" . "(.*)" .
                                "(\[\/swallow\])";

                $matches=array();

                $result =preg_match("/$expr/i", $what, $matches);

                $content=$this->dispatch_swallow($matches[2], $matches[4],
                         $modus);

                return($content);
        }



        //////// swallow //////////////////////////////////////////////////////

        function swallow($what, $modus) {

                $open_pos=strpos($what, '[swallow=');

                while(!($open_pos===false)) {
                        $rest=substr($what, $open_pos+1);
                        $close_pos=strpos($rest, '[/swallow]');

                        if(!($close_pos===false)) {
                                $content=substr($what, $open_pos,
                                        $close_pos+11);

                                $what=substr_replace($what,
                                        $this->parse_swallow($content, $modus),
                                        $open_pos,
                                        $close_pos+11);

                                $open_pos=strpos($what, '[swallow=');
                        } else
                                return($what);
                }

                return($what);

        }




        /**
        * Constructor for the PHPWS_Article_Section object.
        *
        * @author Adam Morton <adam@NOSPAM.tux.appstate.edu>
        * @param int SECT_id : Database id of the section's data to be loaded into the class.
        * @param int data : To optimize the # of table queries, PHPWS_Article can send the
        * data as an array.
        * @return none
        */
        function PHPWS_Article_Section ($SECT_id = NULL, $data = NULL)
        {
                if($SECT_id)
                {
                        if ($data==null)
                        {
                                $result = $GLOBALS['core']->sqlSelect('mod_article_sections', 'id', $SECT_id);
                                $data = &$result[0];
                        }
                        $this->id = $SECT_id;
                        $this->title = $data['title'];
                        $this->text = $data['text'];
                        $this->image['name'] = $data['image_name'];
                        $this->image['directory'] = $data['image_directory'];
                        $this->image['height'] = $data['image_height'];
                        $this->image['width'] = $data['image_width'];
                        $this->image['alt'] = $data['image_alt'];
                        $this->image['link'] = $data['image_link'];
                        $this->image['caption'] = $data['image_caption'];
                        $this->template = $data['template'];
                        $this->new_page = $data['new_page'];
                        $this->article_id = $data['article_id'];
                }
                else
                {
            /* Assign a temporary id to this new section and increment it */
                        $this->id = $_SESSION['SES_ART_article']->sectionID++;
                        $this->title = $this->text = '';
      $this->image['name'] = $this->image['directory'] = $this->image['height']
        = $this->image['width'] = $this->image['alt'] = $this->image['link']
        = $this->image['caption'] = '';
                        $this->template = $_SESSION['SES_ART_master']->val['default_section_template'];
                        $this->new_page = 0;
                }
    $this->edited = 0;
        }

        /**
        * Displays this section in the context of a article object.
        *
        * @author Adam Morton <adam@NOSPAM.tux.appstate.edu>
  * @author Eloi George <eloi@NOSPAM.bygeorgeware.com>
        * @param boolean $edit_mode Simple flag to tell section whether or not the article is in edit mode.
  * @param string article_id : id of this article
  * @param string created_username : username of the user that created this article
  * @param date created_date : Date this article was created
  * @param string updated_username : username of the lastuser to update this article
  * @param date updated_date : Date this article was last updated
        * @return Display data for this section.
        */
        function view_section ($edit_mode = NULL,&$article_id,&$created_username,&$created_date,&$updated_username,&$updated_date)
        {
                include(PHPWS_SOURCE_DIR . 'mod/article/conf/config.php');

                if($this->template)
                {
      /* Develop image appearance */
                        if ($this->image['name'])
                        {
                    /* If this is a temporary image, look in the main directory */
                    if ($this->temp_image)
                $temp_image = $_SESSION['SES_ART_master']->image_directory . $this->image['name'];
                    else
                $temp_image = $_SESSION['SES_ART_master']->image_directory . $this->image['directory'] . $this->image['name'];

                    /* If this is a library picture, calculate image specs on the fly */
                    /* in case the picture has been altered. */
                          if (substr($this->image['directory'],0,7)=='library')
                          {
                            /* Determine image display specs */
                            $image_size = getimagesize($temp_image);
          $this->image['width'] = $image_size[0];
          $this->image['height'] = $image_size[1];
        }

        $image_string = '<img src="./' . $temp_image
            . '" width="' . $this->image['width'] . '" height="'
            . $this->image['height'] . '" alt="' . $this->image['alt']
            . '" title="' . $this->image['alt'] . '" />';
                    if ($this->image['link'])
                $image_string = '<a href="http://' . $this->image['link'] . '">'
                    . $image_string . '</a>';

                          $template_array['IMAGE'] = $image_string;
                    $template_array['CAPTION'] = $this->image['caption'];
      }

                        if (!$this->title) $this->title = ' ';
                        $template_array['TITLE'] = PHPWS_Text::parseOutput($this->title);


                        /* swallow patch, 2004-10-01 rck
                         * "swallows" stuff from other modules, will embed
                         * files from the document manager, thumbnails from
                         * the photoalbum and links from the linkmanager
                         * for instance.
                         */

                        $content = $this->text;

                        $scripting=(strpos($this->text, "noscript")) != false;
                        if($scripting) {
                                $template_array['TEXT'] = $content;
                        } else {
                                $modus=array();
                                if($edit_mode)
                                        $modus["EDIT"]=true;
                                else
                                        $modus["VIEW"]=true;

                                $content=$this->swallow($content, $modus);
                                //$template_array['TEXT'] = PHPWS_Text::parseOutput($content);
                                $template_array['TEXT'] = $content;
                        }

                        /* end of swallow patch */



                        $template_array['PRINT_ICON'] = '<a href="./index.php?module=article&amp;op=view_printable&amp;ARTICLE_id=' . $article_id .
                             '&amp;lay_quiet=1" target="_blank"><img src="mod/article/img/print.gif" border="0" width="22" height="20" alt="Printable Version"/></a>';
                        $template_array['CREATED_DATE'] = $created_date;
                        $template_array['UPDATED_DATE'] = $updated_date;
                        // If Username is blank, substitute "Anonymous"
                        if(!$created_username)
                                $template_array['CREATED_USER'] = $_SESSION['translate']->it('Anonymous');
                        else
                                $template_array['CREATED_USER'] = $created_username;
                        if(!$updated_username)
                                $template_array['UPDATED_USER'] = $_SESSION['translate']->it('Anonymous');
                        else
                                $template_array['UPDATED_USER'] = $updated_username;

                        $section_content = PHPWS_Template::processTemplate($template_array, 'article', 'section/'.$this->template . '.tpl');
                }

                 if ($edit_mode)
                {


            $remove = $_SESSION['translate']->it('Remove');
                        if($_SESSION['OBJ_user']->js_on)
                        {
                                $js_vars['message'] = $_SESSION['translate']->it('Are you sure you want to [var1] [var2]?'
                                    , $_SESSION['translate']->it('delete'), $this->title);
                                $js_vars['name'] = $remove;
                                $js_vars['value'] = 'section=remove:'.$this->id;
                                $js_vars['location'] = 'index.php?module=article&section=remove&SECT_id='.$this->id;
                                $action_form = PHPWS_WizardBag::js_insert('confirm', 'SECT_options', $this->id, 0, $js_vars);
                        }
                        else $action_form = '<input name="ARTICLE_vars[section:remove]" value="'.$remove.'" type="submit">'
                            . CLS_help::show_link('article', 'section_remove');

                        $action_form .= '<input name="ARTICLE_vars[section:edit]" value="'.$_SESSION['translate']->it('Edit').'" type="submit">'
                            . CLS_help::show_link('article', 'section_edit').' ';
            if (count($_SESSION['SES_ART_article']->order)>1)
                        {
                          $action_form .= '<input name="ARTICLE_vars[section:move_up]" value="'.$_SESSION['translate']->it('Move Up').'" type="submit"> ';
                          $action_form .= '<input name="ARTICLE_vars[section:move_down]" value="'.$_SESSION['translate']->it('Move Down').'" type="submit"> '
                . CLS_help::show_link('article', 'section_move');
      }
                        $section_content .= '<div class="smalltext" style="clear:both;text-align:right">'
                . '<form name="SECT_options'.$this->id.'" action="index.php#'.$this->id.'" method="post">'
                . '<input name="module" value="article" type="hidden">'
          . '<input name="SECT_id" value="'.$this->id.'" type="hidden">'
                . $action_form
                . '</form></div><hr />';
                }
                return $section_content;
        }

        /**
        * Displays an editing interface for this section.
        *
        * @author Eloi George <eloi@NOSPAM.bygeorgeware.com>
        * @module Article Manager
        * @param bool first_section : If true, this is the first section of a new article.
        * @return none
        *
        */
        function edit_section ($first_section = false)
        {
                include(PHPWS_SOURCE_DIR . 'mod/article/inc/S_edit.php');
                if($first_section)
      return $content;
    else
      return '<form name="SECT_edit" action="index.php#'.$this->id.'" method="post" enctype="multipart/form-data">'
              . $content
              . '</form><br />';
        }

        /**
        * Applies changes to this section in memory.
        *
        * @author Eloi George <eloi@NOSPAM.bygeorgeware.com>
        * @module Article Manager
        * @param none
        * @return none
        */
        function update ()
        {
                include(PHPWS_SOURCE_DIR . 'mod/article/inc/S_update.php');
        }

        /**
        * Applies this section to the parent Article.
        *
        * @author Eloi George <eloi@NOSPAM.bygeorgeware.com>
        * @module Article Manager
        * @param none
        * @return none
        */
        function commit_to_article ()
        {
                include(PHPWS_SOURCE_DIR . 'mod/article/inc/S_commit_to_article.php');
        }

        /**
        * Saves this section to the database.
        *
        * @author Eloi George <eloi@NOSPAM.bygeorgeware.com>
        * @module Article Manager
        * @param int parentid : ID of the parent article
        * @return none
        */
        function save ($parentid=NULL)
        {
                include(PHPWS_SOURCE_DIR . 'mod/article/inc/S_save.php');
        }

        /**
        * Deletes this section from the database.
        *
        * @author Eloi George <eloi@NOSPAM.bygeorgeware.com>
        * @module Article Manager
        * @param none
        * @return none
        */
        function delete_section ()
        {
                $GLOBALS['core']->sqlDelete('mod_article_sections', 'id', $this->id);
    if ($this->image['name'] && $this->image['directory'] != 'library/')
                  @unlink($_SESSION['SES_ART_master']->image_path.$this->image['directory'].$this->image['name']);
        }
}
?>